#pragma once
#ifndef FRAME_H_
#define FRAME_H_

#include <wx/wx.h>
#include <wx/mediactrl.h>

#include "View.h"
#include "ScriptEvents.h"
#include "TableAdapters/Connection.h"
#include <string>
#include <iostream>

#pragma comment(lib, "Strmiids.lib")
#pragma comment(lib, "comsuppw.lib")
#pragma comment(lib, "kernel32.lib")

class ScriptEvents;

class Frame : public wxFrame
{
	enum WIDGET_IDS
	{
		Quit = 1,
		About_Menu,
		Background_Color,
		Font_Color,
		Physicians_Number,
		Change_Name,
		Submit_Button_Clicked,
		Continue_Button_Clicked,
		Glucose_Button_Clicked,
		Pedometer_Button_Clicked,
		Physician_Button_Clicked,
		Name_Button_Clicked,
		Export_Excel
	};

public:
	Frame(const wxString& title, const wxPoint& pos, const wxSize& size, long style = wxDEFAULT_FRAME_STYLE);
	virtual ~Frame();

	View *_view;
	wxPanel *_inputPanel, *_dummyPanel, *_panel;
	wxBoxSizer *_inputSizer;
	wxTextCtrl *_textBox;
	ScriptEvents *_scriptEvents;
	wxMediaCtrl *_ctrl;
	bool _endOfProgram, _allowScriptMenuEvents;

	void SetFAP(const wxString& filename);
	void SetFDP(const wxString& filename, const wxString& path);
	void SetScriptEvents(ScriptEvents* scriptEvents) {_scriptEvents = scriptEvents;}
	void SetEndOfProgram() {_endOfProgram = true; _allowScriptMenuEvents = false;}

	void ClearInputPanel();
	void SetTextBoxText(const std::string& text);
	void MakeHeadTalk(const std::string& script);

	void SetupPedometerReading();
	void SetupGlucoseReading(const DataAccess::MessageDataTable* glucoseMessagesTable);
	void SetupPhysiciansNumber();
	void AddUserResponse(const DataAccess::MessageDataTable* messageDataTable);
	void AddContinueButton();
	void SetupNamePrompt();

	void OnSubmitButtonClick(wxCommandEvent& event);
	void OnContinueButtonClick(wxCommandEvent& event);
	void OnGlucoseButtonClick(wxCommandEvent& event);
	void OnPedometerButtonClick(wxCommandEvent& event);
	void OnPhysicianButtonClick(wxCommandEvent& event);
	void OnNameButtonClick(wxCommandEvent& event);

	void OnQuit(wxCommandEvent& event);
	void OnAbout(wxCommandEvent& event);
	void OnBackgroundColor(wxCommandEvent& event);
	void OnFontColor(wxCommandEvent& event);
	void OnPhysicianNumber(wxCommandEvent& event);
	void OnNameChange(wxCommandEvent& event);
	void OnExportExcel(wxCommandEvent& event);

	void PlayVideo(std::string videoName);
	void AfterIntroVideo();
	void AfterEndingVideo();

	wxTextCtrl* GetTextBox() const {return _textBox;}
	bool IsEndOfProgram() const {return _endOfProgram;}

private:
	bool _physicianMenuItemClicked, _nameMenuItemClicked;

	DECLARE_CLASS(Frame)
	DECLARE_EVENT_TABLE()
};

class WaitTimer : public wxTimer
{
private:
	virtual void Notify()
		{
			//if the video has loaded
			if(_state == 0)
			{
				_state++;
				_ctrl->Play();
				this->Start(3300, true);
			}
			//if the video has finished playing
			else if(_state == 1)
			{
				//if it is not the end of the program
				if(_frame->IsEndOfProgram() == false)
				{
					_frame->AfterIntroVideo();
				}
				//if it is the end of the program
				else
				{
					_frame->AfterEndingVideo();
				}
			}
		}
	Frame *_frame;
	wxMediaCtrl *_ctrl;
	int _state;
public:
	WaitTimer(Frame *frame, wxMediaCtrl *ctrl) {_frame = frame; _ctrl = ctrl; _state=0;}
};

#endif //FRAME_H_